/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.handler;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import morph.avaritia.item.InfinityArmorItem;
import morph.avaritia.util.InfinityDamageSource;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ArmorHandler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    public static final Set<String> entitiesWithHelmets = new HashSet<String>();
    public static final Set<String> entitiesWithChestplates = new HashSet<String>();
    public static final Set<String> entitiesWithLeggings = new HashSet<String>();
    public static final Set<String> entitiesWithBoots = new HashSet<String>();
    public static final Set<String> entitiesWithFlight = new HashSet<String>();

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(ArmorHandler::livingHurt);
        MinecraftForge.EVENT_BUS.addListener(ArmorHandler::onAttacked);
        MinecraftForge.EVENT_BUS.addListener(ArmorHandler::onDeath);
        MinecraftForge.EVENT_BUS.addListener(ArmorHandler::livingUpdate);
        MinecraftForge.EVENT_BUS.addListener(ArmorHandler::jumpEvent);
    }

    public static boolean isInfinite(Player player) {
        for (ItemStack stack : player.m_150109_().f_35975_) {
            if (!stack.m_41619_() && stack.m_41720_() instanceof InfinityArmorItem) continue;
            return false;
        }
        return true;
    }

    public static void livingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntityLiving().f_19853_.f_46443_) {
                if (event.getSource() == DamageSource.f_19317_ && event.getAmount() == Float.MAX_VALUE) {
                    return;
                }
                if (ArmorHandler.isInfinite(player) && !(event.getSource() instanceof InfinityDamageSource)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    public static void onAttacked(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntityLiving().f_19853_.f_46443_) {
                if (event.getSource().m_7639_() != null && event.getSource().m_7639_() instanceof Player) {
                    return;
                }
                if (event.getSource() == DamageSource.f_19317_ && event.getAmount() == Float.MAX_VALUE) {
                    return;
                }
                if (ArmorHandler.isInfinite(player) && !(event.getSource() instanceof InfinityDamageSource)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntityLiving().f_19853_.f_46443_ && ArmorHandler.isInfinite(player) && !(event.getSource() instanceof InfinityDamageSource) && event.getSource() != DamageSource.f_19317_) {
                event.setCanceled(true);
                player.m_21153_(player.m_21233_());
            }
        }
    }

    public static boolean isPlayerWearing(LivingEntity entity, EquipmentSlot slot, Predicate<Item> predicate) {
        ItemStack stack = entity.m_6844_(slot);
        return !stack.m_41619_() && predicate.test(stack.m_41720_());
    }

    public static void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        String key = entity.m_20149_() + "|" + entity.f_19853_.f_46443_;
        boolean hasHelmet = ArmorHandler.isPlayerWearing(event.getEntityLiving(), EquipmentSlot.HEAD, item -> item instanceof InfinityArmorItem);
        boolean hasChestplate = ArmorHandler.isPlayerWearing(event.getEntityLiving(), EquipmentSlot.CHEST, item -> item instanceof InfinityArmorItem);
        boolean hasLeggings = ArmorHandler.isPlayerWearing(event.getEntityLiving(), EquipmentSlot.LEGS, item -> item instanceof InfinityArmorItem);
        boolean hasBoots = ArmorHandler.isPlayerWearing(event.getEntityLiving(), EquipmentSlot.FEET, item -> item instanceof InfinityArmorItem);
        if (hasHelmet) {
            entitiesWithHelmets.add(key);
            ArmorHandler.handleHelmetStateChange(entity, true);
        }
        if (!hasHelmet) {
            entitiesWithHelmets.remove(key);
            ArmorHandler.handleHelmetStateChange(entity, false);
        }
        if (hasChestplate) {
            entitiesWithChestplates.add(key);
            ArmorHandler.handleChestplateStateChange(entity, true);
        }
        if (!hasChestplate) {
            entitiesWithChestplates.remove(key);
            ArmorHandler.handleChestplateStateChange(entity, false);
        }
        if (hasLeggings) {
            entitiesWithLeggings.add(key);
            ArmorHandler.handleLeggingsStateChange(entity, true);
        }
        if (!hasLeggings) {
            entitiesWithLeggings.remove(key);
            ArmorHandler.handleLeggingsStateChange(entity, false);
        }
        if (hasBoots) {
            ArmorHandler.handleBootsStateChange(entity);
            entitiesWithBoots.add(key);
        }
        if (!hasBoots) {
            ArmorHandler.handleBootsStateChange(entity);
            entitiesWithBoots.remove(key);
        }
        if (entitiesWithHelmets.contains(key)) {
            ArmorHandler.tickHelmetAbilities(entity);
        }
        if (entitiesWithChestplates.contains(key)) {
            ArmorHandler.tickChestplateAbilities(entity);
        }
        if (entitiesWithLeggings.contains(key)) {
            ArmorHandler.tickLeggingsAbilities(entity);
        }
        if (entitiesWithBoots.contains(key)) {
            ArmorHandler.tickBootsAbilities(entity);
        }
    }

    private static void stripAbilities(LivingEntity entity) {
        String key = entity.m_20149_() + "|" + entity.f_19853_.f_46443_;
        if (entitiesWithHelmets.remove(key)) {
            ArmorHandler.handleHelmetStateChange(entity, false);
        }
        if (entitiesWithChestplates.remove(key)) {
            ArmorHandler.handleChestplateStateChange(entity, false);
        }
        if (entitiesWithLeggings.remove(key)) {
            ArmorHandler.handleLeggingsStateChange(entity, false);
        }
        if (entitiesWithBoots.remove(key)) {
            ArmorHandler.handleBootsStateChange(entity);
        }
    }

    private static void handleHelmetStateChange(LivingEntity entity, boolean isNew) {
    }

    private static void handleChestplateStateChange(LivingEntity entity, boolean isNew) {
        String key = entity.m_20149_() + "|" + entity.f_19853_.f_46443_;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (isNew) {
                player.m_150110_().f_35936_ = true;
                entitiesWithFlight.add(key);
            } else if (!player.m_150110_().f_35937_ && entitiesWithFlight.contains(key)) {
                player.m_150110_().f_35936_ = false;
                player.m_150110_().f_35935_ = false;
                entitiesWithFlight.remove(key);
            }
        }
    }

    private static void handleLeggingsStateChange(LivingEntity entity, boolean isNew) {
    }

    private static void handleBootsStateChange(LivingEntity entity) {
        String key = entity.m_20149_() + "|" + entity.f_19853_.f_46443_;
        boolean hasBoots = ArmorHandler.isPlayerWearing(entity, EquipmentSlot.FEET, item -> item instanceof InfinityArmorItem);
        if (hasBoots) {
            entity.f_19793_ = 1.0625f;
            if (!entitiesWithBoots.contains(key)) {
                entitiesWithBoots.add(key);
            }
        } else if (entitiesWithBoots.contains(key)) {
            entity.f_19793_ = 0.6f;
            entitiesWithBoots.remove(key);
        }
    }

    private static void tickHelmetAbilities(LivingEntity entity) {
    }

    private static void tickChestplateAbilities(LivingEntity entity) {
    }

    private static void tickLeggingsAbilities(LivingEntity entity) {
    }

    private static void tickBootsAbilities(LivingEntity entity) {
        boolean swimming;
        boolean flying = entity instanceof Player && ((Player)entity).m_150110_().f_35935_;
        boolean bl = swimming = entity.m_5842_() || entity.m_20069_();
        if (entity.m_20096_() || flying || swimming) {
            boolean sneaking = entity.m_6144_();
            float speed = 0.15f * (flying ? 1.1f : 1.0f) * (sneaking ? 0.1f : 1.0f);
            if (entity.f_20902_ > 0.0f) {
                entity.m_19920_(speed, new Vec3(0.0, 0.0, 1.0));
            } else if (entity.f_20902_ < 0.0f) {
                entity.m_19920_(-speed * 0.3f, new Vec3(0.0, 0.0, 1.0));
            }
            if (entity.f_20900_ != 0.0f) {
                entity.m_19920_(speed * 0.5f * Math.signum(entity.f_20900_), new Vec3(1.0, 0.0, 0.0));
            }
        }
    }

    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entitiesWithBoots.contains(entity.m_20149_() + "|" + entity.f_19853_.f_46443_)) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
        }
    }
}

